/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.tools.InspirationsTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ThornsEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolsEvents {
    @SubscribeEvent
    public static void lockAndUnlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isLock;
        if (!Config.enableLock.getAsBoolean()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(event.getHand());
        boolean isKey = stack.m_41720_() == InspirationsTools.key;
        boolean bl = isLock = stack.m_41720_() == InspirationsTools.lock;
        if (!isKey && !isLock) {
            return;
        }
        BlockEntity te = event.getLevel().m_7702_(event.getPos());
        if (te instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity lockable = (BaseContainerBlockEntity)te;
            LockCode heldCode = new LockCode(stack.m_41786_().getString());
            if (isLock) {
                if (lockable.f_58621_ != LockCode.f_19102_) {
                    player.m_5661_((Component)Component.m_237115_((String)Inspirations.prefix("lock.fail.locked")), true);
                } else if (!stack.m_41788_()) {
                    player.m_5661_((Component)Component.m_237115_((String)Inspirations.prefix("lock.fail.blank")), true);
                } else {
                    lockable.f_58621_ = heldCode;
                    lockable.m_6596_();
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    player.m_5661_((Component)Component.m_237115_((String)Inspirations.prefix("lock.success")), true);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            } else if (player.m_6047_()) {
                if (lockable.f_58621_ != LockCode.f_19102_) {
                    if (lockable.f_58621_.m_19107_(stack)) {
                        LockCode code = lockable.f_58621_;
                        lockable.f_58621_ = LockCode.f_19102_;
                        lockable.m_6596_();
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)InspirationsTools.lock).m_41714_((Component)Component.m_237113_((String)code.f_19103_)));
                        player.m_5661_((Component)Component.m_237115_((String)Inspirations.prefix("unlock.success")), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)Inspirations.prefix("unlock.fail.no_match")), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)Inspirations.prefix("unlock.fail.unlocked")), true);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void vineBreakEvent(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor;
        if (!Config.harvestHangingVines.getAsBoolean()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getLevel().m_5776_() || !((levelAccessor = event.getLevel()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)levelAccessor;
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        Block block = event.getState().m_60734_();
        if (!(block instanceof VineBlock)) {
            return;
        }
        VineBlock vine = (VineBlock)block;
        ItemStack shears = player.m_21205_();
        if (shears.canPerformAction(ToolActions.SHEARS_DIG)) {
            return;
        }
        BlockPos pos = event.getPos().m_7495_();
        BlockState state = world.m_8055_(pos);
        int count = 0;
        while (state.m_60734_() == block && vine.isShearable(shears, (Level)world, pos) && !ToolsEvents.vineCanStay((Level)world, state, pos)) {
            ++count;
            for (ItemStack stack : state.m_60724_(new LootContext.Builder(world).m_78972_(LootContextParams.f_81463_, (Object)shears).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81455_, (Object)player))) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
            }
            pos = pos.m_7495_();
            state = world.m_8055_(pos);
        }
        for (int i = 0; i < count; ++i) {
            pos = pos.m_7494_();
            world.m_7471_(pos, false);
        }
    }

    private static boolean vineCanStay(Level world, BlockState state, BlockPos pos) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.m_61143_((Property)VineBlock.m_57883_((Direction)side))).booleanValue() || !VineBlock.m_57853_((BlockGetter)world, (BlockPos)pos.m_121945_(side), (Direction)side)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    static void onShieldHit(LivingAttackEvent event) {
        if (!Config.moreShieldEnchantments.getAsBoolean()) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (target.f_19853_.f_46443_ || !target.m_21254_()) {
            return;
        }
        ItemStack stack = target.m_21211_();
        int thorns = stack.getEnchantmentLevel(Enchantments.f_44972_);
        int fire = stack.getEnchantmentLevel(Enchantments.f_44981_);
        int knockback = stack.getEnchantmentLevel(Enchantments.f_44980_);
        if (thorns == 0 && fire == 0 && knockback == 0) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.m_7640_();
        if (attacker != null && !target.m_6673_(source) && target.m_21275_(source)) {
            if (thorns > 0 && ThornsEnchantment.m_220316_((int)thorns, (RandomSource)target.f_19853_.f_46441_)) {
                attacker.m_6469_(DamageSource.m_19335_((Entity)target), (float)ThornsEnchantment.m_220319_((int)thorns, (RandomSource)target.f_19853_.f_46441_));
                stack.m_41622_(1, target, play -> play.m_21190_(target.m_7655_()));
            }
            if (fire > 0) {
                attacker.m_20254_(fire * 4);
            }
            if (knockback > 0) {
                if (attacker instanceof LivingEntity) {
                    ((LivingEntity)attacker).m_147240_((double)((float)knockback * 0.5f), (double)Mth.m_14031_((float)(target.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(target.m_146908_() * ((float)Math.PI / 180)))));
                    if (attacker instanceof ServerPlayer) {
                        InspirationsNetwork.sendPacket(attacker, new ClientboundSetEntityMotionPacket(attacker));
                    }
                } else {
                    attacker.m_5997_((double)(-Mth.m_14031_((float)(target.m_146908_() * ((float)Math.PI / 180))) * (float)knockback * 0.5f), 0.1, (double)(Mth.m_14089_((float)(target.m_146908_() * ((float)Math.PI / 180))) * (float)knockback * 0.5f));
                }
            }
        }
    }
}

