/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.item.RetexturedBlockItem;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static IIngredientManager ingedientManager;
    private static final List<HideState> HIDABLE_ITEMS;

    public ResourceLocation getPluginUid() {
        return Inspirations.getResource("jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter texture = (ingredient, context) -> RetexturedBlockItem.getTextureName((ItemStack)ingredient);
        Consumer<ItemLike> setTextureSubtype = item -> registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)item.m_5456_(), texture);
        InspirationsBuilding.shelf.values().forEach(setTextureSubtype);
        InspirationsBuilding.enlightenedBush.values().forEach(setTextureSubtype);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)InspirationsBuilding.coloredBook, (stack, context) -> context == UidContext.Ingredient ? Integer.toHexString(((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack)) : "");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ingedientManager = jeiRuntime.getIngredientManager();
        HIDABLE_ITEMS.clear();
        for (ItemStack item : ingedientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (!(item.m_41720_() instanceof IHidable)) continue;
            HIDABLE_ITEMS.add(new HideState(item));
        }
        Config.setJEIUpdateRunnable(JEIPlugin::updateHiddenItems);
    }

    private static void updateHiddenItems() {
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>();
        ArrayList<ItemStack> visible = new ArrayList<ItemStack>();
        for (HideState state : HIDABLE_ITEMS) {
            boolean enabled = ((IHidable)state.stack.m_41720_()).isEnabled();
            if (enabled == state.visible) continue;
            if (enabled) {
                visible.add(state.stack);
            } else {
                hidden.add(state.stack);
            }
            state.visible = enabled;
        }
        if (hidden.size() > 0) {
            ingedientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hidden);
        }
        if (visible.size() > 0) {
            ingedientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, visible);
        }
    }

    static {
        HIDABLE_ITEMS = new ArrayList<HideState>();
    }

    private static class HideState {
        private final ItemStack stack;
        private boolean visible;

        private HideState(ItemStack item) {
            this.stack = item;
            this.visible = true;
        }
    }
}

