/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import knightminer.inspirations.Inspirations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import slimeknights.mantle.data.listener.IEarlyReloadListener;
import slimeknights.mantle.util.JsonHelper;

public class CustomTextureLoader
implements IEarlyReloadListener {
    private final Map<ResourceLocation, ResourceLocation> textures = new HashMap<ResourceLocation, ResourceLocation>();
    private final ResourceLocation file;

    public CustomTextureLoader(ResourceLocation file) {
        this.file = new ResourceLocation(file.m_135827_(), "models/" + file.m_135815_() + ".json");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTextureStitch);
    }

    public void onResourceManagerReload(ResourceManager manager) {
        List<JsonObject> jsonFiles = manager.m_213829_(this.file).stream().map(resource -> JsonHelper.getJson((Resource)resource, (ResourceLocation)this.file)).filter(Objects::nonNull).toList();
        for (JsonObject json : jsonFiles) {
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ResourceLocation name = ResourceLocation.m_135820_((String)key);
                if (name == null) {
                    Inspirations.log.error("Skipping invalid key " + key + " as it is not a valid resource location");
                    continue;
                }
                if (!ModList.get().isLoaded(name.m_135827_())) {
                    Inspirations.log.debug("Skipping loading texture " + key + " as the dependent mod is not loaded");
                    continue;
                }
                JsonElement element = (JsonElement)entry.getValue();
                if (!element.isJsonPrimitive()) {
                    Inspirations.log.error("Skipping key " + key + " as the value is not a string");
                    continue;
                }
                ResourceLocation texture = ResourceLocation.m_135820_((String)element.getAsString());
                if (texture == null) {
                    Inspirations.log.error("Skipping key " + key + " as the texture " + element.getAsString() + " is an invalid texture path");
                    continue;
                }
                this.textures.put(name, texture);
            }
        }
    }

    private void onTextureStitch(TextureStitchEvent.Pre event) {
        if (InventoryMenu.f_39692_.equals((Object)event.getAtlas().m_118330_())) {
            this.textures.values().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    public ResourceLocation getTexture(ResourceLocation location) {
        return this.textures.getOrDefault(location, location);
    }
}

