/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import knightminer.inspirations.Inspirations;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigurableResourcePack
extends AbstractPackResources
implements RepositorySource {
    private final Class<?> resourceLoader;
    private final String packId;
    private final String displayName;
    private final String pathPrefix;
    private final Set<String> namespaces;
    private final Map<String, Replacement> replacements = new HashMap<String, Replacement>();

    public ConfigurableResourcePack(Class<?> resourceLoader, ResourceLocation packId, String displayName, Set<String> namespaces) {
        this(resourceLoader, packId.toString(), String.format("/%s/%s/%s/", PackType.CLIENT_RESOURCES.m_10305_(), packId.m_135827_(), packId.m_135815_()), displayName, namespaces);
    }

    private ConfigurableResourcePack(Class<?> resourceLoader, String packId, String pathPrefix, String displayName, Set<String> namespaces) {
        super(new File(pathPrefix));
        this.resourceLoader = resourceLoader;
        this.packId = packId;
        this.displayName = displayName;
        this.pathPrefix = pathPrefix;
        this.namespaces = namespaces;
    }

    public String m_8017_() {
        return this.displayName;
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? this.namespaces : Collections.emptySet();
    }

    private InputStream getPackResource(String name) throws IOException {
        InputStream stream = this.resourceLoader.getResourceAsStream(this.pathPrefix + name);
        if (stream != null) {
            return stream;
        }
        throw new FileNotFoundException("Failed to open resource at " + this.pathPrefix + name);
    }

    protected InputStream m_5541_(String name) throws IOException {
        if (name.equals("pack.mcmeta") || name.equals("pack.png")) {
            return this.getPackResource(name);
        }
        Replacement replacement = this.replacements.get(name);
        if (replacement != null && replacement.isEnabled()) {
            return this.getPackResource(replacement.getName());
        }
        throw new ResourcePackFileNotFoundException(this.f_10203_, name);
    }

    protected boolean m_6105_(String name) {
        Replacement replacement = this.replacements.get(name);
        return replacement != null && replacement.isEnabled();
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String domain, String path, Predicate<ResourceLocation> filter) {
        return Collections.emptyList();
    }

    public void close() {
    }

    public void m_7686_(Consumer<Pack> consumer, Pack.PackConstructor factory) {
        consumer.accept(Pack.m_10430_((String)this.packId, (boolean)true, () -> this, (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.TOP, name -> Component.m_237110_((String)"pack.nameAndSource", (Object[])new Object[]{name, "inspirations"})));
    }

    public void addReplacement(BooleanSupplier condition, String originalPath, String resource) {
        Replacement original = this.replacements.putIfAbsent(originalPath, new Replacement(condition, resource));
        if (original != null) {
            Inspirations.log.warn("Duplicate replacement '{}' for configurable pack {}.", (Object)originalPath, (Object)this.packId);
        }
    }

    private static String makePath(ResourceLocation id, String folder, String extension) {
        return String.format("%s/%s/%s/%s.%s", PackType.CLIENT_RESOURCES.m_10305_(), id.m_135827_(), folder, id.m_135815_(), extension);
    }

    public void addBlockstateReplacement(BooleanSupplier condition, Block block, String resource) {
        this.addReplacement(condition, ConfigurableResourcePack.makePath(Registry.f_122824_.m_7981_((Object)block), "blockstates", "json"), "blockstates/" + resource + ".json");
    }

    public void addBlockstateReplacement(ForgeConfigSpec.BooleanValue condition, Block block, String resource) {
        this.addBlockstateReplacement(() -> ((ForgeConfigSpec.BooleanValue)condition).get(), block, resource);
    }

    public void addItemModelReplacement(BooleanSupplier condition, ItemLike item, String resource) {
        this.addReplacement(condition, ConfigurableResourcePack.makePath(Registry.f_122827_.m_7981_((Object)item.m_5456_()), "models/item", "json"), "item_models/" + resource + ".json");
    }

    public void addItemModelReplacement(ForgeConfigSpec.BooleanValue condition, ItemLike item, String resource) {
        this.addItemModelReplacement(() -> ((ForgeConfigSpec.BooleanValue)condition).get(), item, resource);
    }

    private static class Replacement {
        private final BooleanSupplier condition;
        private final String name;

        public Replacement(BooleanSupplier condition, String name) {
            this.name = name;
            this.condition = condition;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.condition.getAsBoolean();
        }
    }
}

