/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class MiscUtil {
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_COLOR = "color";
    private static final ItemStack silkTouchItem = new ItemStack((ItemLike)Items.f_42398_);
    private static final int[] DYE_COLORS;

    public static VoxelShape makeRotatedShape(Direction side, int x1, int y1, int z1, int x2, int y2, int z2) {
        float yaw = -1.5707964f * (float)side.m_122416_();
        Vec3 first = new Vec3((double)(x1 - 8), (double)(y1 - 8), (double)(z1 - 8)).m_82524_(yaw);
        Vec3 second = new Vec3((double)(x2 - 8), (double)(y2 - 8), (double)(z2 - 8)).m_82524_(yaw);
        return Shapes.m_83048_((double)(0.5 + Math.min(first.f_82479_, second.f_82479_) / 16.0), (double)(0.5 + Math.min(first.f_82480_, second.f_82480_) / 16.0), (double)(0.5 + Math.min(first.f_82481_, second.f_82481_) / 16.0), (double)(0.5 + Math.max(first.f_82479_, second.f_82479_) / 16.0), (double)(0.5 + Math.max(first.f_82480_, second.f_82480_) / 16.0), (double)(0.5 + Math.max(first.f_82481_, second.f_82481_) / 16.0));
    }

    public static ItemStack getStackFromState(ServerLevel world, @Nullable BlockState state) {
        if (state == null) {
            return ItemStack.f_41583_;
        }
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_) {
            return ItemStack.f_41583_;
        }
        List drops = state.m_60724_(new LootContext.Builder(world).m_78972_(LootContextParams.f_81460_, (Object)new Vec3(0.5, 64.0, 0.5)).m_78972_(LootContextParams.f_81463_, (Object)silkTouchItem));
        if (drops.size() > 0) {
            return (ItemStack)drops.get(0);
        }
        InspirationsRegistry.log.error("Failed to get silk touch drop for {}, using fallback", (Object)state);
        Item item = Item.m_41439_((Block)block);
        if (item == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    @SafeVarargs
    @Deprecated
    public static <E> NonNullList<E> createNonNullList(E ... elements) {
        NonNullList list = NonNullList.m_122779_();
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static int combineColors(int color1, int color2, int scale) {
        if (scale == 0) {
            return color1;
        }
        int a = color1 >> 24 & 0xFF;
        int r = color1 >> 16 & 0xFF;
        int g = color1 >> 8 & 0xFF;
        int b = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        for (int i = 0; i < scale; ++i) {
            a = (int)Math.sqrt(a * a2);
            r = (int)Math.sqrt(r * r2);
            g = (int)Math.sqrt(g * g2);
            b = (int)Math.sqrt(b * b2);
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getColor(DyeColor color) {
        return DYE_COLORS[color.m_41060_()];
    }

    public static int getColorInteger(float[] component) {
        return ((int)(component[0] * 255.0f) & 0xFF) << 16 | ((int)(component[1] * 255.0f) & 0xFF) << 8 | (int)(component[2] * 255.0f) & 0xFF;
    }

    @Nullable
    public static DyeColor getDyeForColor(int color) {
        for (DyeColor dyeColor : DyeColor.values()) {
            if (MiscUtil.getColor(dyeColor) != color) continue;
            return dyeColor;
        }
        return null;
    }

    public static int getColor(ItemStack stack) {
        CompoundTag display;
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            return ((DyeableLeatherItem)item).m_41121_(stack);
        }
        CompoundTag tags = stack.m_41783_();
        if (tags != null && (display = tags.m_128469_(TAG_DISPLAY)).m_128425_(TAG_COLOR, 3)) {
            return display.m_128451_(TAG_COLOR);
        }
        return -1;
    }

    public static boolean hasColor(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            return ((DyeableLeatherItem)item).m_41113_(stack);
        }
        CompoundTag tags = stack.m_41737_(TAG_COLOR);
        return tags != null && tags.m_128425_(TAG_COLOR, 99);
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            ((DyeableLeatherItem)item).m_41115_(stack, color);
        } else {
            stack.m_41698_(TAG_DISPLAY).m_128405_(TAG_COLOR, color);
        }
        return stack;
    }

    public static ItemStack clearColor(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            ((DyeableLeatherItem)item).m_41123_(stack);
        } else {
            CompoundTag displayTag = stack.m_41737_(TAG_DISPLAY);
            if (displayTag != null && displayTag.m_128441_(TAG_COLOR)) {
                displayTag.m_128473_(TAG_COLOR);
            }
        }
        return stack;
    }

    public static Item deserializeItem(JsonObject parent, String key) {
        String name = GsonHelper.m_13906_((JsonObject)parent, (String)key);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            throw new JsonSyntaxException("Invalid " + key + ": Unknown item " + name + "'");
        }
        return item;
    }

    public static void notifyClientUpdate(BlockEntity te) {
        Level world = te.m_58904_();
        if (world != null && world.f_46443_) {
            te.requestModelDataUpdate();
            BlockState state = te.m_58900_();
            world.m_7260_(te.m_58899_(), state, state, 36);
        }
    }

    public static void shrinkHeldItem(Player player, InteractionHand hand, ItemStack held, int count) {
        if (!player.m_150110_().f_35937_) {
            held.m_41774_(count);
            if (held.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
    }

    public static void givePlayerItem(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    private static int divide(int sum, int pref, int divisor) {
        int color = sum / divisor;
        if (sum % divisor != 0 && pref > color) {
            ++color;
        }
        return color;
    }

    private static int getRed(int color) {
        return (color & 0xFF0000) >> 16;
    }

    private static int getGreen(int color) {
        return (color & 0xFF00) >> 8;
    }

    private static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int addColors(int newColor, int newLevels, int original, int origLevels) {
        int nr = MiscUtil.getRed(newColor);
        int ng = MiscUtil.getGreen(newColor);
        int nb = MiscUtil.getBlue(newColor);
        int r = nr * newLevels + MiscUtil.getRed(original) * origLevels;
        int g = ng * newLevels + MiscUtil.getGreen(original) * origLevels;
        int b = nb * newLevels + MiscUtil.getBlue(original) * origLevels;
        int c = origLevels + newLevels;
        return MiscUtil.divide(r, nr, c) << 16 | MiscUtil.divide(g, ng, c) << 8 | MiscUtil.divide(b, nb, c);
    }

    public static void addParticles(ParticleOptions type, Level world, BlockPos pos, int count, double offset, RandomSource rand) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            double y = (double)pos.m_123342_() + offset;
            double z = (double)pos.m_123343_() + 0.1875 + (double)rand.m_188501_() * 0.625;
            world.m_7106_(type, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static {
        silkTouchItem.m_41663_(Enchantments.f_44985_, 1);
        DYE_COLORS = new int[16];
        for (DyeColor color : DyeColor.values()) {
            MiscUtil.DYE_COLORS[color.m_41060_()] = MiscUtil.getColorInteger(color.m_41068_());
        }
    }
}

