/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons.interaction.potion;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.cauldrons.block.BoilingFourLayerCauldronBlock;
import knightminer.inspirations.cauldrons.block.entity.PotionCauldronBlockEntity;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingCauldronInteraction
implements CauldronInteraction {
    @Nullable
    private final Potion fixedInput;
    private static PotionBrewing.Mix<Potion> lastMix;
    private static final Function<Potion, ItemStack> POTION_ITEM_MAPPER;
    private static final Map<Potion, ItemStack> POTION_ITEM_LOOKUP;
    private static IBrewingRecipe lastRecipe;

    public BrewingCauldronInteraction(@Nullable Potion fixedInput) {
        this.fixedInput = fixedInput;
    }

    public InteractionResult m_175710_(BlockState oldState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (BoilingFourLayerCauldronBlock.isBoiling(level, pos)) {
            Potion newPotion;
            PotionCauldronBlockEntity cauldron = null;
            Potion oldPotion = this.fixedInput;
            if (oldPotion == null) {
                cauldron = (PotionCauldronBlockEntity)InspirationsCaudrons.potionCauldronEntity.m_58949_((BlockGetter)level, pos);
                if (cauldron == null) {
                    return InteractionResult.PASS;
                }
                oldPotion = cauldron.getPotion();
            }
            if ((newPotion = BrewingCauldronInteraction.getVanillaResult(oldPotion, stack)) == Potions.f_43598_) {
                newPotion = BrewingCauldronInteraction.getForgeResult(oldPotion, stack);
            }
            if (newPotion != Potions.f_43598_) {
                if (!level.f_46443_) {
                    if (this.fixedInput != null) {
                        level.m_46597_(pos, (BlockState)InspirationsCaudrons.potionCauldron.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)((Integer)oldState.m_61143_((Property)LayeredCauldronBlock.f_153514_))));
                        cauldron = (PotionCauldronBlockEntity)InspirationsCaudrons.potionCauldronEntity.m_58949_((BlockGetter)level, pos);
                        if (cauldron == null) {
                            return InteractionResult.CONSUME;
                        }
                    }
                    cauldron.setPotion(newPotion);
                    ItemStack container = stack.getCraftingRemainingItem();
                    MiscUtil.shrinkHeldItem(player, hand, stack, 1);
                    if (!container.m_41619_()) {
                        MiscUtil.givePlayerItem(player, container.m_41777_());
                    }
                    player.m_36220_(Stats.f_12944_);
                    level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static Potion tryMix(PotionBrewing.Mix<Potion> mix, Potion potion, ItemStack stack) {
        Potion output;
        if (mix.f_43532_.get() == potion && mix.f_43533_.test(stack) && (output = (Potion)mix.f_43534_.get()) != null) {
            return output;
        }
        return Potions.f_43598_;
    }

    private static Potion getVanillaResult(Potion potion, ItemStack stack) {
        Potion output;
        if (lastMix != null && (output = BrewingCauldronInteraction.tryMix(lastMix, potion, stack)) != Potions.f_43598_) {
            return output;
        }
        for (PotionBrewing.Mix mix : PotionBrewing.f_43494_) {
            Potion output2 = BrewingCauldronInteraction.tryMix((PotionBrewing.Mix<Potion>)mix, potion, stack);
            if (output2 == Potions.f_43598_) continue;
            lastMix = mix;
            return output2;
        }
        return Potions.f_43598_;
    }

    private static Potion tryForgeRecipe(IBrewingRecipe recipe, ItemStack potion, ItemStack stack) {
        ItemStack outputStack = recipe.getOutput(potion, stack);
        if (!outputStack.m_41619_()) {
            return PotionUtils.m_43579_((ItemStack)outputStack);
        }
        return Potions.f_43598_;
    }

    private static Potion getForgeResult(Potion potion, ItemStack stack) {
        Potion output;
        ItemStack input = POTION_ITEM_LOOKUP.computeIfAbsent(potion, POTION_ITEM_MAPPER);
        if (lastRecipe != null && (output = BrewingCauldronInteraction.tryForgeRecipe(lastRecipe, input, stack)) != Potions.f_43598_) {
            return output;
        }
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            Potion output2;
            if (recipe instanceof VanillaBrewingRecipe || (output2 = BrewingCauldronInteraction.tryForgeRecipe(recipe, input, stack)) == Potions.f_43598_) continue;
            lastRecipe = recipe;
            return output2;
        }
        return Potions.f_43598_;
    }

    static {
        POTION_ITEM_MAPPER = potion -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
        POTION_ITEM_LOOKUP = new IdentityHashMap<Potion, ItemStack>();
    }
}

