/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassDoorBlock
extends DoorBlock
implements IHidable {
    private static final VoxelShape[] SHAPES = new VoxelShape[16];

    public GlassDoorBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return (Boolean)state.m_61143_((Property)f_52727_) != false ? BlockPathTypes.DOOR_OPEN : BlockPathTypes.DOOR_WOOD_CLOSED;
    }

    @Override
    public boolean isEnabled() {
        return Config.enableGlassDoor.getAsBoolean();
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.m_49811_(group, items);
        }
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return super.m_5940_(state, worldIn, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean flipped;
        Direction direction = (Direction)state.m_61143_((Property)f_52726_);
        boolean bl = flipped = state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT;
        if (((Boolean)state.m_61143_((Property)f_52727_)).booleanValue()) {
            direction = flipped ? direction.m_122428_() : direction.m_122427_();
            flipped = !flipped;
        }
        int half = state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? 8 : 0;
        return SHAPES[direction.m_122416_() | half | (flipped ? 4 : 0)];
    }

    static {
        for (boolean onTop : new boolean[]{false, true}) {
            for (Direction yaw : Direction.Plane.HORIZONTAL) {
                int ind = (onTop ? 8 : 0) | yaw.m_122416_();
                VoxelShape door = MiscUtil.makeRotatedShape(yaw, 0, 0, 0, 16, 16, 3);
                int z1 = onTop ? 0 : 6;
                int z2 = onTop ? 9 : 16;
                VoxelShape handleL = MiscUtil.makeRotatedShape(yaw, 4, z1, -2, 5, z2, 5);
                VoxelShape handleR = MiscUtil.makeRotatedShape(yaw, 11, z1, -2, 12, z2, 5);
                GlassDoorBlock.SHAPES[ind] = Shapes.m_83110_((VoxelShape)door, (VoxelShape)handleL);
                GlassDoorBlock.SHAPES[ind | 4] = Shapes.m_83110_((VoxelShape)door, (VoxelShape)handleR);
            }
        }
    }
}

